<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Psr\Log\LoggerInterface;

class PaymentPlaceObserver implements ObserverInterface
{
    private LoggerInterface $logger;

    public function __construct(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    public function execute(Observer $observer): void
    {
        $payment = $observer->getEvent()->getPayment();

        if ($payment->getMethod() !== 'layerpay_cryptopay') {
            return;
        }

        $txHash = $payment->getAdditionalInformation('tx_hash');
        $orderId = $payment->getOrder()->getIncrementId();

        $this->logger->info('LayerPay payment placed', [
            'order_id' => $orderId,
            'tx_hash' => $txHash
        ]);
    }
}
