<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class Currency implements OptionSourceInterface
{
    public function toOptionArray(): array
    {
        return [
            [
                'value' => 'ETH',
                'label' => __('ETH (Ethereum)')
            ],
            [
                'value' => 'USDC',
                'label' => __('USDC (USD Coin)')
            ],
            [
                'value' => 'USDT',
                'label' => __('USDT (Tether)')
            ],
            [
                'value' => 'MATIC',
                'label' => __('MATIC (Polygon)')
            ]
        ];
    }

    public function toArray(): array
    {
        $options = [];
        foreach ($this->toOptionArray() as $option) {
            $options[$option['value']] = $option['label'];
        }
        return $options;
    }
}
