<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Gateway\Response;

use Magento\Payment\Gateway\Response\HandlerInterface;

class CaptureHandler implements HandlerInterface
{
    public function handle(array $handlingSubject, array $response): void
    {
        $paymentDO = $handlingSubject['payment'] ?? null;

        if (!$paymentDO) {
            return;
        }

        $payment = $paymentDO->getPayment();
        $txHash = $response['tx_hash'] ?? null;

        if ($txHash) {
            $payment->setTransactionId($txHash . '-capture');
            $payment->setParentTransactionId($txHash);
            $payment->setIsTransactionClosed(true);
        }
    }
}
