<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Gateway\Request;

use Magento\Payment\Gateway\Request\BuilderInterface;

class CaptureRequest implements BuilderInterface
{
    public function build(array $buildSubject): array
    {
        $payment = $buildSubject['payment'] ?? null;
        $amount = $buildSubject['amount'] ?? 0;

        $data = [
            'amount' => $amount,
            'capture' => true
        ];

        if ($payment) {
            $paymentDO = $payment;
            $data['tx_hash'] = $paymentDO->getPayment()->getAdditionalInformation('tx_hash');
        }

        return $data;
    }
}
