<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Block\Adminhtml\System\Config;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Data\Form\Element\AbstractElement;

class PaymentInfo extends Field
{
    protected function _getElementHtml(AbstractElement $element): string
    {
        return '
        <div style="padding: 15px; background: #f5f5f5; border-radius: 4px; border-left: 4px solid #667eea;">
            <h4 style="margin: 0 0 10px 0; color: #333;">LayerPay CryptoPay Module</h4>
            <p style="margin: 0; color: #666; font-size: 13px;">
                Accept cryptocurrency payments (ETH, USDC) on multiple blockchain networks.<br>
                Supports MetaMask and WalletConnect for seamless customer experience.<br><br>
                <strong>Supported Networks:</strong> Ethereum, Polygon, Arbitrum, Base (+ testnets)<br>
                <strong>Supported Currencies:</strong> ETH, USDC, MATIC
            </p>
        </div>';
    }
}
